#!/usr/bin/env python3.6
print("# pip3.6 install azure-cli --user ")
import os
import sys
import datetime
import pytz
import collections  # to use OrderedDict, DefaultDict
import json

#from azhelper import az_cli
from pprint import pprint as pp
rootdir = "../configs/tokensvc-osp-config"
if not os.path.exists(rootdir):
    rootdir = "configs/tokensvc-osp-config"

#Get dirs
maindirs = [ d for d in os.scandir(rootdir) if d.is_dir() ]
# print("maindirs:",maindirs)
data = collections.defaultdict(dict)  # simplified dict in dict
data_envs = set()
data_channels = set()
data_osps = set()
for env in maindirs:
    data_channels.add(env.name)
    #print(env.name)
    for subdir, dirs , files in os.walk( env , topdown=True):
        for file in files:
            filename, file_extension = os.path.splitext(file)
            data_envs.add(filename)
            # print(env.name, filename, file_extension , subdir)
            with open( os.path.join(subdir,file), 'r') as f:
                j = json.load(f)
                for entry in j:
                    data_osps.add(entry['osp'])
                    #print("entry",entry, env.name + "-" + filename)
                    data[ entry['osp'] ][ env.name + "-" + filename ] = entry


print("data_envs",data_envs)
print("data_channels",data_channels)
print("data_osps",data_osps)

def genOSPtable():
    print()
    print("Start - print wiki page ..")
    header = "| Env"
    header_break = "|--"
    for o in data_osps:
        header = header + " | " + o
        header_break = header_break + "|--"
    header = header + " |"
    header_break = header_break + "|"
    print(header)
    print(header_break)
    for c in data_channels:
        for e in data_envs:
            line = "| " + f"{c}-{e}"
            for o in data_osps:
                if f"{c}-{e}" in data[ o ]:
                    client_id = data[ o ][ f"{c}-{e}" ].get('client_id',f"No {o} client_id")
                    line = line + " | client_id:\"" + client_id + '"'

                    for note in [ key for key in data[ o ][f"{c}-{e}"] if key.startswith("note") ]:
                        line = line + ", " + note + ':"' + data[ o ][ f"{c}-{e}" ][ note ] + '"'
                else:
                    line = line + " | " + "n.a."
                    #print( data[o] , f"{c}-{e}" )
            else:
                line = line + " |"
            print(line)
    print( header)  # at bottom again
    print()
###########################
def genENVtable():
    print()
    print("Start - print wiki page ..")
    header = "| OSP"
    header_break = "|--"
    for c in sorted(data_channels):
        for e in sorted(data_envs):
            header = header + " | " + f"{c}-{e}"
            header_break = header_break + "|--"
    header = header + " | OSP |"
    header_break = header_break + "|--|"
    print(header)
    print(header_break)
    for o in sorted(data_osps):
        line = "| osp:" + o
        for c in sorted(data_channels):
            for e in sorted(data_envs):
                if f"{c}-{e}" in data[ o ]:
                    for id_name in ["client_id", "consumer_key"]:
                        if id_name in data[ o ][ f"{c}-{e}" ]:
                            id = data[ o ][ f"{c}-{e}" ][ id_name ]
                            id = id[0:3] + ".." + id[-3:]
                            line = line + " | " + id_name + ':"' + id + '"'
                            break
                    else:
                        line = line + " | NO " + o + ' id'
                    for note in [ key for key in data[ o ][f"{c}-{e}"] if key.startswith("note") ]:
                        line = line + ", " + note + ':"' + data[ o ][ f"{c}-{e}" ][ note ] + '"'
                else:
                    line = line + " | " + "n.a."
                    #print( data[o] , f"{c}-{e}" )

        else:
            line = line + " | osp:" + o + " |"
        print(line)
    print( header)  # at bottom again
    print()


# genOSPtable()
genENVtable()
#print(data_osps)
print("The End.")



