#!/bin/bash
for subscription in "Infrastructure" "Non-Prod" "Prod"
do
    echo
    echo "# az aks list for \"$subscription\" "
    az aks list --subscription "$subscription" | jq "[ .[] |
        {name: .name, k8sV: .kubernetesVersion,
        sp: .servicePrincipalProfile.clientId,
        NetPolicy: .networkProfile.networkPolicy,
        Nodes: ((.agentPoolProfiles[0].count|tostring) + \"/\" + ( .agentPoolProfiles[0].maxCount|tostring ) + \" \" + .agentPoolProfiles[0].provisioningState),
        psp: .enablePodSecurityPolicy,
        rbac: .enableRbac,
        apiAuth: .apiServerAccessProfile.authorizedIpRanges,
        }]"

done
